$FP_NONE = 0;
$FP_WALK = 1;
$FP_BUILD = 2;
$FP_ALL = 3;

/********************* BASE DATABLOCK OBJECT TYPES ***********************/

datablock CCmpBuildingData(BaseBuildingData)
{
   // building settings
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 0;
};

/********************* BASE DATABLOCK OBJECT TYPES ***********************/

/* BANK ------------------------------------------------------------------
-------------------------------------------------------------------------*/

// Bank Datablock
datablock CCmpBuildingData(BankData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 2;
   
   // door offset from position
   door = "2 5 0";
   
   buildHappiness = "3 1";
   happinessString = "Bank Financial Security";
   
   // construction building properties
   constructionProp = "3 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts " @ $Detail::Medium;
   constructionProp = "-3 0 180 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "-1 1 0 1 ~/data/shapes/props/townProps/constructpropbricks.dts";
   constructionProp = "1 4 90 1 ~/data/shapes/props/townProps/constructproptable.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionScale = 7;
   constructionOffset = "0 0";
   constructionScale = 6;
   constructionTime = 20;
   constructionPresentStart = 3;
   constructionPresentStop = 18;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-4 1 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "4 -2 0 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "0 0 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionScale = 7;
   destructionOffset = "0 0";
   destructionScale = 6;
   destructionTime = 10;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 10;
   repaitWood = 7;
   
   //work information
   workUniform = "banker";
   workerAI = "com_default";
   workItem = "Moneybag 2 male_and_female";
   workItem = "Bankerhat 0 male_and_female";
   workAnimation = "idle00";
};

// Bank Object
datablock SLGameObjData(Bank)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";
   
   addCmpData = BankData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/bank.dts";
   
   // health
   healthMax = 250;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 300;
   woodCost = 200;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "16 16";
	footprintSetRow = "0 3 3 3 3 0 0 0 0 0 0 0 0 3 3 3 3";
	footprintSetRow = "1 3 3 3 3 0 0 0 0 0 0 0 0 3 3 3 3";
	footprintSetRow = "2 3 3 3 3 0 0 0 0 0 0 0 0 3 3 3 3";
	footprintSetRow = "3 3 3 3 3 0 0 0 0 0 0 0 0 3 3 3 3";
	footprintSetRow = "4 3 3 3 3 0 0 0 0 0 0 0 0 3 3 3 3";
	footprintSetRow = "5 3 3 3 3 0 0 0 0 0 0 0 0 3 3 3 3";
	footprintSetRow = "6 3 3 3 3 0 0 0 0 0 0 0 0 3 3 3 3";
	footprintSetRow = "7 3 3 3 3 0 0 0 0 0 0 0 0 3 3 3 3";
	footprintSetRow = "8 3 3 3 3 3 3 4 4 4 4 3 3 3 3 3 3";
	footprintSetRow = "9 3 3 3 3 3 3 4 4 4 4 3 3 3 3 3 3";
	footprintSetRow = "10 3 3 1 1 1 1 4 4 4 4 1 1 1 1 3 3";
	footprintSetRow = "11 3 3 1 1 1 1 4 4 4 4 1 1 1 1 3 3";
	footprintSetRow = "12 3 3 1 1 1 1 4 4 4 4 1 1 1 1 3 3";
	footprintSetRow = "13 3 3 1 1 1 1 4 4 4 4 1 1 1 1 3 3";
	footprintSetRow = "14 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3";
	footprintSetRow = "15 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3";
	footprintCenter = "8 4";
	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
   // shadow for the object
	shadowDecal = BankShadowDecal;
	shadowScale = 6.5;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = ".1 -1.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;

	//addLight = "0 3.5 7.5 sgRedLightDataBlock";

	portraitOffset = "1 -0.7 6.4";
	portraitRotation = "12";
	portraitHeight = "11";
	portraitZoom = "25";
	portraitAngle = "9";
	portraitFOV = "24";
	portraitImageMale = "assets/client/ui/hud/malecivbanker_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivbanker_portrait";

	addHotSpot = "5 9 315";
	addHotSpot = "11 9 45";

	//audio
	audioList = "SEL : bank_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 15;
	selectionIcon = true;
   
   // Goodie death props
	deathPropMin = 1;
	deathPropMax = 2;
   deathProp = "chest goldbagpickup moneybagpickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 0 0";  // the location to place the death props
   
   //Effects
   addGameEffect = "fire smallFireEffectronData -3.1 2.7 1 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -3.1 2.7 2 " @ $Detail::High;
   addGameEffect = "fire FireEffectronData 3 0.7 5.5 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 3 0.7 6.5 " @ $Detail::High;
   addGameEffect = "fire FireEffectronData 2 2.2 4 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 2 2.2 5 " @ $Detail::High;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;

	//Naming
	nameKey = "bank_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_BNK01 m_civilian_BNK02 m_civilian_BNK03";
	fConstructSound = "f_civilian_BNK01 f_civilian_BNK02 f_civilian_BNK03";
	
};

/* BARBERSHOP -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Barber shop Datablock
datablock CCmpBuildingData(BarbershopData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 1;
   
   // door offset from position
   door = "0 6 0";

   buildHappiness = "2 1";
   happinessString = "Barber Shop Fashion";

   // construction building properties
   constructionProp = "-5 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2.5 -3 0 1 ~/data/shapes/props/townProps/constructpropbricks.dts " @ $Detail::Medium;
   constructionProp = "-3 0 0 1 ~/data/shapes/props/townProps/barrel.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 7;
   constructionTime = 18;
   constructionPresentStart = 2;
   constructionPresentStop = 16;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-4 0 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "0 2 180 1 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructionProp = "0 0 180 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 7;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 13;
   repairGold = 10;
   repaitWood = 7;
   
   //work information
   workUniform = "bartender";
   workerAI = "com_default";
   workItem = "Broom 2 male_and_female";
   workItem = "Phonyhat 0 male_and_female";
   workAnimation = "sweep";
};

// Barber shop Object
datablock SLGameObjData(Barbershop)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";
      
   // Components
   addCmpData = BarbershopData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/barbershop.dts";
   
   // health
   healthMax = 190;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 180;
   woodCost = 180;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "12 16";
	footprintSetRow = "0 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "1 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "2 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "3 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "4 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "5 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "6 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "7 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "8 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "9 3 3 0 0 0 4 4 0 0 0 3 3";
	footprintSetRow = "10 3 3 3 3 4 4 4 4 3 3 3 3";
	footprintSetRow = "11 3 3 3 3 4 4 4 4 3 3 3 3";
	footprintSetRow = "12 1 1 1 1 4 4 4 4 1 1 1 1";
	footprintSetRow = "13 1 1 1 1 4 4 4 4 1 1 1 1";
   footprintSetRow = "14 1 1 1 1 4 4 4 4 1 1 1 1";
   footprintSetRow = "15 1 1 1 1 4 4 4 4 1 1 1 1";
	footprintCenter = "6 6";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	// shadow for the object
	shadowDecal = BarbershopShadowDecal;
	shadowScale = 6;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = ".5 -.5 4.9";
	portraitRotation = "20";
	portraitHeight = "9.5";
	portraitZoom = "25";
	portraitAngle = "7";
	portraitFOV = "20";
	portraitImageMale = "assets/client/ui/hud/malecivclerk_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivclerk_portrait";
	
	addHotSpot = "5 11 0";
	addHotSpot = "-1 11 0";

	//audio
	audioList = "SEL : barbershop_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 15;
	selectionIcon = true;
	
	
	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 2;
   deathProp = "woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2";  // the location to place the death props
	
	//effects
   addGameEffect = "fire FireEffectronData 3.3 -1 3 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 3.3 -1 4 " @ $Detail::High;
   addGameEffect = "fire FireEffectronData 2 2.2 4.5 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 2 2.2 5.5 " @ $Detail::High;
   addGameEffect = "fire smallFireEffectronData -1.9 2.3 1.5 " @ $Detail::Low;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;

	//Naming
	nameKey = "barbershop_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_BSO01 m_civilian_BSO02 m_civilian_BSO03";
	fConstructSound = "f_civilian_BSO01 f_civilian_BSO02 f_civilian_BSO03 f_civilian_BSO04 f_civilian_BSO05";
};

/* Blacksmith -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Blacksmith Datablock
datablock CCmpBuildingData(BlacksmithData)
{
   hiderMax = 3;
   employeeMax = 2;

   // door offset from position
   door = "-6 7 0";

   // construction building properties
   constructionProp = "-5 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts"; 
   constructionProp = "0 4 0 1 ~/data/shapes/props/townProps/constructpropwood.dts " @ $Detail::Medium;
   constructionProp = "2.5 -3 0 1 ~/data/shapes/props/townProps/constructpropbricks.dts"; 
   constructionProp = "-3 3 0 1 ~/data/shapes/props/townProps/barrel.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 8;
   constructionTime = 24;
   constructionPresentStart = 3;
   constructionPresentStop = 22;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-6 -1 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "3 -2 270 1 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructionProp = "2 2 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "-4 3 -45 1 ~/data/shapes/props/townProps/destructionprop1.dts " @ $Detail::Medium;
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "-1 -1";
   destructionScale = 8;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 10;
   repaitWood = 10;
   
   //work information
   workUniform = "Blacksmith";
   workerAI = "com_default";
   workItem = "hammer 2 male_and_female";
   workItem = "Phonyhat 0 male_and_female";
   workAnimation = "repair";
   
   // turn off building rotation
   facingDir = 0;
};

// Blacksmith Object
datablock SLGameObjData(Blacksmith)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   // Components
   addCmpData = BlacksmithData;
   addCmpData = BlacksmithCmdData;
   
   shapeFile = "~/data/shapes/buildings/blacksmith.dts";
   
   // health
   healthMax = 300;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 3";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 350;
   woodCost = 300;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "16 24";
	footprintSetRow = "0 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "2 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "3 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "4 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "5 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "6 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "7 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "8 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "9 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "10 4 4 4 4 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5";
	footprintSetRow = "11 4 4 4 4 1 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "12 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "13 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "14 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "15 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";

	footprintCenter = "6 6";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	// shadow for the object
	shadowDecal = BlacksmithShadowDecal;
	shadowScale = 6.9;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0.4 -0.2";
	shadowAngleStatic = 180;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = ".5 -.2 4.5";
	portraitRotation = "28";
	portraitHeight = "8";
	portraitZoom = "22";
	portraitAngle = "8";
	portraitFOV = "23";
	portraitImageMale = "assets/client/ui/hud/malecivblacksmith_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivblacksmith_portrait";

	addHotSpot = "5 14 180";
	addHotSpot = "8 11 90";

	//audio
	audioList = "SEL : blacksmith_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 2;
	deathPropMax = 2;
   deathProp = "woodpickup goldbagpickup cratepickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1";  // the location to place the death props
   
   //Effects
   addGameEffect = "produce smokeEffectronData 1.4 0.5 8 " @ $Detail::High;
   addGameEffect = "produce sparkEffectronData 1.5 2 2 " @ $Detail::Medium;
   addGameEffect = "produce fireEffectronData 1.5 2 1.8 " @ $Detail::Low;
   addGameEffect = "fire fireEffectronData -2.3 2.5 6.3 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -2.3 2.5 7.3 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 4.3 -2.8 4.2 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 4.3 -2.8 5.2 " @ $Detail::High;
   addGameEffect = "fire smallfireEffectronData -3 3.4 1.5 " @ $Detail::Low;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
	
	//Naming
	nameKey = "blacksmith_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_BMT01 m_civilian_BMT02 m_civilian_BMT03 m_civilian_BMT04";
	fConstructSound = "f_civilian_BMT01 f_civilian_BMT02 f_civilian_BMT03 f_civilian_BMT04";
};

/* Cemetery -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Cemetery Datablock
datablock CCmpBuildingData(CemeteryData)
{
   // door offset from position
   door = "-6 7 0";

   // construction building properties
   constructionProp = "0 4 0 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2.5 -3 0 1 ~/data/shapes/props/townProps/constructpropbricks.dts " @ $Detail::Medium;
   constructionProp = "-3 3 0 1 ~/data/shapes/props/townProps/barrel.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 8;
   constructionTime = 15;
   constructionPresentStart = 1;
   constructionPresentStop = 14;

   // health and damage states for the building
   damageData = "100 0 base";

   // destruction building properties
   destructionProp = "3 -2 270 1 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructionProp = "2 2 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "-4 3 -45 1 ~/data/shapes/props/townProps/destructionprop1.dts " @ $Detail::Medium;
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "-1 -1";
   destructionScale = 8;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 10;
   repairGold = 4;
   repaitWood = 4;
   
   flammable = false;
   
   buildHappiness = "4 3 2";
   happinessString = "Cemetery";   
   
   // turn off building rotation
   facingDir = 1;
};

// Cemetery Object
datablock SLGameObjData(Cemetery)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   // Components
   addCmpData = CemeteryData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/cemetery.dts";
   
   // health
   healthMax = 200;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 100;
   woodCost = 100;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "16 20";
	footprintSetRow = "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "10 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "11 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "12 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "13 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "14 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "15 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1";

	footprintCenter = "8 6";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
		
	portraitOffset = ".5 -.2 4.5";
	portraitRotation = "28";
	portraitHeight = "9";
	portraitZoom = "25";
	portraitAngle = "0";
	portraitFOV = "25";
		
	sightRange = 10;
	selectionIcon = true;
   
	//Naming
	nameKey = "cemetery_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_CMT01 m_civilian_CMT02";
	fConstructSound = "f_civilian_CMT01 f_civilian_CMT03 f_civilian_CMT04";
};

/* CHURCH ------------------------------------------------------------------
-------------------------------------------------------------------------*/

// Church Datablock
datablock CCmpBuildingData(ChurchData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 0;
   
   // door offset from position
   door = "0 6 0";
   
   buildHappiness = "5 3 1";
   happinessString = "Church Spirit";
   
   // construction building properties
   constructionProp = "-5 1 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "5 -1 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts " @ $Detail::Medium;
   constructionProp = "0 3 0 1 ~/data/shapes/props/townProps/constructproptable.dts " @ $Detail::Medium;
   constructionProp = "0 -3 0 1 ~/data/shapes/props/townProps/constructpropbricks.dts";
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 7;
   constructionTime = 15;
   constructionPresentStart = 2;
   constructionPresentStop = 14;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "0 -1 0 1 ~/data/shapes/props/townProps/destructionprop3.dts";
   destructionProp = "2 0 0 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "0 0 90 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 6;
   destructionTime = 10;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 8;
   repaitWood = 6;
};

// Church Object
datablock SLGameObjData(Church)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   addCmpData = ChurchData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/church.dts";
   
   // health
   healthMax = 250;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 -3";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 180;
   woodCost = 150;
   
   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "12 16";
	footprintSetRow = "0 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "1 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "2 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "3 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "4 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "5 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "6 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "7 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "8 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "9 3 3 0 0 0 4 4 0 0 0 3 3";
	footprintSetRow = "10 3 3 3 3 4 4 4 4 3 3 3 3";
	footprintSetRow = "11 3 3 3 3 4 4 4 4 3 3 3 3";
	footprintSetRow = "12 1 1 1 1 4 4 4 4 1 1 1 1";
	footprintSetRow = "13 1 1 1 1 4 4 4 4 1 1 1 1";
   footprintSetRow = "14 1 1 1 1 4 4 4 4 1 1 1 1";
   footprintSetRow = "15 1 1 1 1 4 4 4 4 1 1 1 1";
	footprintCenter = "6 6";
	
	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	receiveLMLighting = false;
	
	// shadow for the object
	shadowDecal = ChurchShadowDecal;
	shadowScale = 4.5;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
   portraitOffset = ".5 -.1 2.6";
	portraitRotation = "15";
	portraitHeight = "8";
	portraitZoom = "26";
	portraitAngle = "2";
	portraitFOV = "24";
	
	//audio
	audioList = "SEL : church_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 2;
	deathPropMax = 3;
   deathProp = "woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1";  // the location to place the death props
	
	//Effects
	addGameEffect = "fire fireEffectronData 2.5 0 6 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 2.5 0 7 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData 0.2 2.7 6 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 2.5 0 7 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData 0 1.4 12.4 " @ $Detail::Low;
	addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "church_name";
	
   // Construction finished sounds
   constructSoundChance = "100";
	mConstructSound = "m_civilian_CHU01 m_civilian_CHU02 m_civilian_CHU03";
	fConstructSound = "f_civilian_CHU01";
};

/* FARM ------------------------------------------------------------------
-------------------------------------------------------------------------*/

// used to grow wheat on the farm
datablock StaticShapeData(WheatData)
{
   shapeFile = "~/data/shapes/props/forestprops/wheat.dts";
   reloadProduce = true;
};

// used to grow corn on the farm
datablock StaticShapeData(CornData)
{
   shapeFile = "~/data/shapes/props/forestprops/corn.dts";
   reloadProduce = true;
};

// used to grow pumpkins on the farm
datablock StaticShapeData(PumpkinData)
{
   shapeFile = "~/data/shapes/props/forestprops/pumpkin.dts";
   reloadProduce = true;
};

// Farm Datablock
datablock CCmpBuildingData(FarmData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 4;

   // door offset from position
   door = "-1 5 0";
   
   // default point production settings
   produce = "wheat";
   produceType = $Resource::Food;
   
   // wheat production
   addProduceTime = "wheat 30 20 0";
   addProduceRates = "wheat 0 3 5 8 10";
   addProduceDatablock = "wheat WheatData";
   
   addProducePoint = "wheat -5.5 2 0";
   addProducePoint = "wheat -5.5 0.5 0";
   addProducePoint = "wheat -5.5 -1.5 0";
   addProducePoint = "wheat -5.5 -3 0";
   
   addProducePoint = "wheat -9 2 0";
   addProducePoint = "wheat -9 0.5 0";
   addProducePoint = "wheat -9 -1.5 0";
   addProducePoint = "wheat -9 -3 0";
   
   // corn production
   addProduceTime = "corn 30 20 0";
   addProduceRates = "corn 0 4 6 9 12";
   addProduceDatablock = "corn CornData";
   
   addProducePoint = "corn -5.5 2.2 0";
   addProducePoint = "corn -5.5 0 0";
   addProducePoint = "corn -5.5 -3.2 0";
   addProducePoint = "corn -9 2.2 0";
   addProducePoint = "corn -9 0 0";
   addProducePoint = "corn -9 -3.2 0";
   
   // pumpkin production
   addProduceTime = "pumpkin 30 20 0";
   addProduceRates = "pumpkin 0 3 4 6 8";
   addProduceDatablock = "pumpkin PumpkinData";
   addProducePoint = "pumpkin -5.5 1.25 0";
   addProducePoint = "pumpkin -5.5 -2.75 0";
   addProducePoint = "pumpkin -9 1.25 0";
   addProducePoint = "pumpkin -9 -2.75 0";

   // construction building properties
   constructionProp = "-4 1 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "7 -2 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "2.5 1 45 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "-8.5 0 0 0.8 ~/data/shapes/props/townProps/constructproplogs.dts " @ $Detail::Medium;
   constructionProp = "2 -3 90 1 ~/data/shapes/props/townProps/constructproptable.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionScale = 8.5;
   constructionOffset = "4 0";
   constructionScale = 6;
   constructionTime = 20;
   constructionPresentStart = 4;
   constructionPresentStop = 19;
   
   // building consumption information
   consumeWater = "0 3 5 8 10";
   
   // production building properties
   produceFoodCap = 5;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "5 -1 0 1 ~/data/shapes/props/townProps/destructionprop1.dts " @ $Detail::Medium;
   destructionProp = "-1 0 90 1 ~/data/shapes/props/townProps/destructionprop3.dts";
   destructionProp = "1 0 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "-2 0 270 1 ~/data/shapes/props/townProps/destructionprop2.dts";
   destructionProp = "-2 -5 315 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;

   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "1 -1";
   destructionScale = 9;
   destructionTime = 10;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 5;
   repaitWood = 6;

   //work information
   workUniform = "base";
   workerAI = "com_default";
   workItem = "Hoe 2 male_and_female";
   workItem = "Farmerhat 0 male";
   workItem = "Farmerhat 0 female";
   workAnimation = "hoe";
};

// Farm Object
datablock SLGameObjData(Farm)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   addCmpData = FarmData;
   addCmpData = FarmCmdData;
   
   shapeFile = "~/data/shapes/buildings/farm.dts";
   
   // health
   healthMax = 250;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 2";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 100;
   woodCost = 170;

   //footprint
  footprintGrid = $SnapGrid::Object;
	footprintSize = "28 16";
	footprintSetRow = "0 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "1 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "2 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "3 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "4 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "5 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "6 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "7 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "8 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 0 0 0 5 5 5";
	footprintSetRow = "9 5 5 5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5 5 5 5 5 5 5";
	footprintSetRow = "10 5 5 5 5 5 5 5 5 5 5 5 5 4 4 4 4 5 5 5 5 5 5 5 5 5 5 5 5";
	footprintSetRow = "11 5 5 5 5 5 5 5 5 5 5 5 5 4 4 4 4 5 5 5 5 5 5 5 5 5 5 5 5";
	footprintSetRow = "12 3 1 1 1 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "13 3 1 1 1 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "14 3 1 1 1 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "15 3 1 1 1 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintCenter = "14 6";
	
	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	receiveLMLighting = false;
	
	// shadow for the object
	shadowDecal = FarmShadowDecal;
	shadowScale = 8;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "3 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "-3 -.5 3.5";
	portraitRotation = "15";
	portraitHeight = "8";
	portraitZoom = "28";
	portraitAngle = "3";
	portraitFOV = "25";
	portraitImageMale = "assets/client/ui/hud/malecivfarmer_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivfarmer_portrait";

	addHotSpot = "1 3 270";
	addHotSpot = "7 10 180";
	addHotSpot = "4 10 180";
	addHotSpot = "1 6 270";

	//audio
	audioList = "SEL : farm_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 2;
	deathPropMax = 3;
   deathProp = " woodpickup crate";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1";  // the location to place the death props
	
	//Effects
	addGameEffect = "fire fireEffectronData 5 3 6.5 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 5 3 7.5 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData 3.5 0.2 12 " @ $Detail::Low;
	addGameEffect = "fire fireEffectronData 0.2 2.7 5.5 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 0.2 2.7 6.5 " @ $Detail::High;
	addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
	addGameEffect = "plague farmEffectronData 0 0 2 " @ $Detail::Low;
   
	//Naming
	nameKey = "farm_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_FAR01 m_civilian_FAR03";
	fConstructSound = "f_civilian_FAR01 f_civilian_FAR02 f_civilian_FAR03 f_civilian_FAR04";
};

// GAZEBO -----------------------------------------------------------------

// Gazebo Datablock
datablock CCmpBuildingData(GazeboData)
{
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 0;

   // door offset from position
   door = "0 4 0";
   
   // construction building properties
   constructionProp = "0 0 90 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "-2 -1 0 0.8 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 6.5;
   constructionTime = 15;
   constructionPresentStart = 5;
   constructionPresentStop = 14;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "0 0 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 6;
   destructionTime = 8;

   // repair info
   repairTime = 3;
   repairAmount = 10;
   repairGold = 5;
   repaitWood = 5;
   
   buildHappiness = "8 5 3";
   happinessString = "Gazebo Appeal";
};

// Gazebo Object
datablock SLGameObjData(Gazebo)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";
   
   addCmpData = GazeboData;
   addCmpData = BaseCmdData;

   shapeFile = "~/data/shapes/buildings/gazebo.dts";

   // health
   healthMax = 100;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 80;
   woodCost = 80;
   
   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 0 0 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 0 0 1";
	footprintSetRow = "5 1 0 0 0 0 0 0 1";
	footprintSetRow = "6 1 0 0 0 0 0 0 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";
	
	receiveLMLighting = false;
	
	smallMinimapIcon = true;
	
	// shadow for the object
	shadowDecal = GazeboShadowDecal;
	shadowScale = 3.8;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = ".5 0 4";
	portraitRotation = "20";
	portraitHeight = "8";
	portraitZoom = "20";
	portraitAngle = "-1";
	portraitFOV = "25";
	
	//audio
	audioList = "SEL : gazebo_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";

	sightRange = 15;
	selectionIcon = true;
	
		//Effects
	addGameEffect = "fire fireEffectronData 1.5 1.5 5.6 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 1.5 1.5 5.9 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData -.95 2.78 5 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData -.95 2.78 5.5 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData -0.5 0 7.5 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData -.5 0 7.7 " @ $Detail::High;

   
	//Naming
	nameKey = "gazebo_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_GZB01 m_civilian_GZB02 m_civilian_GZB03";
	fConstructSound = "f_civilian_GZB01 f_civilian_GZB02 f_civilian_GZB03 f_civilian_GZB05";
};

/* GOLDMINE -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// waterfall
datablock StaticShapeData(waterfallData)
{
   shapeFile = "~/data/shapes/buildings/minewater.dts";
   reloadProduce = false;
};
function waterfallData::onAdd(%this,%obj)
{
  %obj.playThread(0, "ambient");
}

// Goldmine Datablock
datablock CCmpTargetBuildingData(GoldmineData)
{
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 4;

   // door offset from position
   door = "6 4 0";
   
   // default point production settings
   produce = "waterfall";
   produceType = $Resource::Gold;
   
   // waterfall prop
   addProduceTime = "waterfall 30 0 0";
   addProduceRates = "waterfall 0 10 15 20 25";
   addProduceDatablock = "waterfall waterfallData";
   addProducePoint = "waterfall 0 0 0 0";

   // construction building properties
   constructionProp = "-4 1 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts " @ $Detail::Medium;
   constructionProp = "6 -2 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "2.5 3 45 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "-8.5 0 0 0.8 ~/data/shapes/props/townProps/constructproplogs.dts " @ $Detail::Medium;
   constructionProp = "0 -4 0 1 ~/data/shapes/props/townProps/barrel.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = "7.5";
   constructionTime = 15;
   constructionPresentStart = 2;
   constructionPresentStop = 14;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // production building properties
   produceTime = 30;
   produceGold = "0 12 18 25 30";

   // destruction building properties
   destructionProp = "-4 4 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "-4 -3 0 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "0 0 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "4 2 45 0.8 ~/data/shapes/props/townProps/destructionpropwood.dts " @ $Detail::Medium;
   destructionProp = "5 0 0 1 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 7;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 20;
   repairGold = 2;
   repaitWood = 4;
   
   // mines, what the building will look for to gather gold from
   addTargetDatablock = goldvein;
	targetRadius = 2;
   
   //work information
   workUniform = "base";
   workerAI = "com_default";
   workItem = "pickaxe 2 male_and_female";
   workItem = "minerhat 0 male_and_female";
   workAnimation = "repair";      
   
   snapPlacement = "GoldVein";
   snapRadius = 5;
   
   // turn off building rotation
   facingDir = 0;
};

// Gold mine Object
datablock SLGameObjData(Goldmine)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   // Components
   addCmpData = GoldmineData;
   addCmpData = BaseCmdData;

   shapeFile = "~/data/shapes/buildings/goldmine.dts";
   
   // health
   healthMax = 200;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 20;
   woodCost = 75;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "16 18";
	footprintSetRow = "0 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5";
	footprintSetRow = "1 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5";
	footprintSetRow = "2 1 1 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "3 1 1 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "4 1 1 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "5 1 1 5 0 0 3 3 3 3 3 3 0 0 0 0 0 0 0";
	footprintSetRow = "6 1 1 5 0 0 3 3 3 3 3 3 0 0 0 0 0 0 0";
	footprintSetRow = "7 1 1 5 0 0 3 3 3 3 3 3 0 0 0 0 0 0 0";
	footprintSetRow = "8 1 1 5 0 0 3 3 3 3 3 3 0 0 0 0 0 0 0";
	footprintSetRow = "9 1 1 5 0 0 3 3 3 3 3 3 0 0 0 0 0 0 0";
	footprintSetRow = "10 1 1 5 0 0 3 3 3 3 3 3 0 0 0 0 0 0 0";
	footprintSetRow = "11 1 1 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "12 1 1 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "13 1 1 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "14 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "15 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintCenter = "8 8";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
   bindFootprintTexture = "1 " @ $Texture::Road;

	receiveLMLighting = false;
	
	portraitOffset = "3 0 3";
	portraitRotation = "75";
	portraitHeight = "8";
	portraitZoom = "22";
	portraitAngle = "2";
	portraitFOV = "25";
	portraitImageMale = "assets/client/ui/hud/malecivminer_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivminer_portrait";

	addHotSpot = "14 2 70";
	addHotSpot = "14 6 90";
	addHotSpot = "14 10 90";
	addHotSpot = "8 0 0";

	//audio
	audioList = "SEL : goldmine_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 10;
	selectionIcon = true;
   
	//Naming
	nameKey = "goldmine_name";
	
	// effects
   addGameEffect = "fire fireEffectronData -1 2 9 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -1.2 2.2 9.2 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 1.5 0 8.8 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 1.5 0 9 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 0 3.6 3 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 0 4 3.3 " @ $Detail::High;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
	addGameEffect = "produce waterEffectronData -3.4 3.8 3.6 " @ $Detail::High;
	addGameEffect = "produce waterEffectronData -3.4 3.8 0.9 " @ $Detail::High;
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_GMI01 m_civilian_GMI02 m_civilian_GMI03";
	fConstructSound = "f_civilian_GMI01 f_civilian_GMI02 f_civilian_GMI03";
};


/* GRANARY ----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Granary Datablock
datablock CCmpBuildingData(GranaryData)
{
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 0;

   // door offset from position
   door = "0 3 0";

   produceFoodCap = 10;
   
   // construction building properties
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 -2 0 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 4.5;
   constructionTime = 20;
   constructionPresentStart = 4;
   constructionPresentStop = 19;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "0 1 45 0.8 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 5;
   destructionTime = 10;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 4;
   repaitWood = 5;
};

// Granary Object
datablock SLGameObjData(Granary)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";
   
	addCmpData = GranaryData;
	addCmpData = BaseCmdData;

   shapeFile = "~/data/shapes/buildings/granary.dts";
   
   // health
   healthMax = 150;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   
   // resource requirements to build object
   goldCost = 40;
   woodCost = 60;
   
   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "6 6";
	footprintSetRow = "0 1 1 1 1 1 1";
	footprintSetRow = "1 1 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 1";
	footprintSetRow = "5 1 1 1 1 1 1";
	footprintCenter = "3 3";
	
	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	
	receiveLMLighting = false;
	
	smallMinimapIcon = true;
	
	// shadow for the object
	shadowDecal = GranaryShadowDecal;
	shadowScale = 3;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 4";
	portraitRotation = "40";
	portraitHeight = "8";
	portraitZoom = "19";
	portraitAngle = "2";
	portraitFOV = "26";
	
	//audio
	audioList = "SEL : granary_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";

   sightRange = 5;
   selectionIcon = true;
   
    // Goodie death props
	deathPropMin = 2;
	deathPropMax = 2;
   deathProp = "woodpickup applebasket";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2";  // the location to place the death props
   
   //effect
   addGameEffect = "fire fireEffectronData 1.2 -0.6 6.5 " @ $Detail::Low;
   addGameEffect = "fire fireEffectronData -0.3 1.7 6.2 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -0.3 1.7 7 " @ $Detail::Low;
   addGameEffect = "fire smallfireEffectronData 0.7 2 1.2 " @ $Detail::Low;
   
	//Naming
	nameKey = "granary_name";
	
	// Construction finished sounds
	constructSoundChance = "80";
	mConstructSound = "m_civilian_GRA01 m_civilian_GRA02 m_civilian_GRA03";
	fConstructSound = "f_civilian_GRA01 f_civilian_GRA02";
};

/* LOGCABIN ----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Log Cabin Datablock
datablock CCmpBuildingData(LogcabinData)
{
   hiderMax = 2;
   tenantMax = 2;
   employeeMax = 0;

   // door offset from position
   door = "-1 4 0";

   // construction building properties
   constructionProp = "4 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "0 0 45 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "-3.5 0 0 0.8 ~/data/shapes/props/townProps/constructproplogs.dts " @ $Detail::Medium;
   constructionProp = "1 3 20 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 7;
   constructionTime = 20;
   constructionPresentStart = 3;
   constructionPresentStop = 18;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-3 2 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "4 -2 0 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "0 0 25 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 6;
   destructionTime = 10;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 5;
   repaitWood = 6;
   
   // respawn time
   respawnTime = 40;
};

// Log cabin Object
datablock SLGameObjData(Logcabin)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";
   addCmpData = LogcabinData;
   addCmpData = BaseCmdData;
   
   // resource requirements to build object
   goldCost = 50;
   woodCost = 80;

	shapeFile = "~/data/shapes/buildings/logcabin.dts";
   
   // health
   healthMax = 140;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "10 14";
	footprintSetRow = "0 5 0 0 0 0 0 0 0 0 5";
	footprintSetRow = "1 5 0 0 0 0 0 0 0 0 5";
	footprintSetRow = "2 5 0 0 0 0 0 0 0 0 5";
	footprintSetRow = "3 5 0 0 0 0 0 0 0 0 5";
	footprintSetRow = "4 5 0 0 0 0 0 0 0 0 5";
	footprintSetRow = "5 5 0 0 0 0 0 0 0 0 5";
	footprintSetRow = "6 5 0 0 0 0 0 0 0 0 5";
	footprintSetRow = "7 5 0 0 0 0 0 0 0 0 5";
	footprintSetRow = "8 5 0 0 1 1 1 1 0 0 5";
	footprintSetRow = "9 5 0 0 1 1 1 1 0 0 5";
	footprintSetRow = "10 4 1 1 1 1 1 1 1 1 4";
	footprintSetRow = "11 4 1 1 1 1 1 1 1 1 4";
	footprintSetRow = "12 4 1 1 1 1 1 1 1 1 4";
	footprintSetRow = "13 4 1 1 1 1 1 1 1 1 4";
	footprintCenter = "5 4";
	
	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;

	// shadow for the object
	shadowDecal = LogcabinShadowDecal;
	shadowScale = 5.1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 180;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 .1 4.5";
	portraitRotation = "15";
	portraitHeight = "8";
	portraitZoom = "20";
	portraitAngle = "3";
	portraitFOV = "25";
	
	//audio
	audioList = "SEL : logcabin_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 15;
	selectionIcon = true;
	
	//Naming
	nameKey = "logcabin_name";
	
	// Construction finished sounds
	constructSoundChance = "80";
	mConstructSound = "m_civilian_LCA01 m_civilian_LCA02 m_civilian_LCA03";
	fConstructSound = "f_civilian_LCA01 f_civilian_LCA02";
	
	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 2;
   deathProp = "woodpickup  moneybagpickup woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1";  // the location to place the death props
	
	// effects
   addGameEffect = "produce WhtsmokeEffectronData 3.2 -1 6.5 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 1 2 4.5 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 1 2 5.5 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData -2.6 1.2 4.5 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -2.6 1.2 5.5 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData -0.6 -0.2 5.8 " @ $Detail::Low;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
};

/* HOTEL ------------------------------------------------------------------
-------------------------------------------------------------------------*/

// Hotel Datablock
datablock CCmpBuildingData(HotelData)
{
   hiderMax = 6;
   tenantMax = 5;
   employeeMax = 0;
   
   // door offset from position
   door = "5 4 0";
   
   buildHappiness = "5 3 1";
   happinessString = "Hotel Commercialization";
   
   // construction building properties
   constructionProp = "5 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "2 5 90 1 ~/data/shapes/props/townProps/constructpropschaffold.dts " @ $Detail::Medium;
   constructionProp = "0 0 45 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "-3 0 0 1 ~/data/shapes/props/townProps/constructproplogs.dts " @ $Detail::Medium;
   constructionProp = "-6 -3 0 0.9 ~/data/shapes/props/townProps/constructpropbricks.dts";
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 8;
   constructionTime = 30;
   constructionPresentStart = 4;
   constructionPresentStop = 29;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-9 -3 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "1 -3 270 1 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructionProp = "-6 3 270 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "-2 -1 270 1 ~/data/shapes/props/townProps/destructionpropwood.dts";


   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "-3 -2";
   destructionScale = 9;
   destructionTime = 8;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 10;
   repaitWood = 8;
   
   // respawn time
   respawnTime = 35;
   
   // housing values
   housingOffset = 0;
   
   // turn off building rotation
   facingDir = 0;
};

// Hotel Object
datablock SLGameObjData(Hotel)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   addCmpData = HotelData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/hotel.dts";
   
   // health
   healthMax = 300;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 2";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 250;
   woodCost = 220;

   //footprint
   footprintGrid = $SnapGrid::object;
	footprintSize = "24 20";
	footprintSetRow = "0 1 1 1 1 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 3 3";
	footprintSetRow = "1 1 1 1 1 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 3 3";
	footprintSetRow = "2 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "3 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "5 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "6 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "7 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "8 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "9 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "10 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "11 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "12 4 4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "13 4 4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "14 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "15 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "16 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "17 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "18 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 3 3";
	footprintSetRow = "19 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 3 3";
	footprintCenter = "14 8";
	
	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	receiveLMLighting = false;
	
	// shadow for the object
	shadowDecal = HotelShadowDecal;
	shadowScale = 7.8;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-2.3 -.5";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = ".5 -0.8 3.4";
	portraitRotation = "19";
	portraitHeight = "8";
	portraitZoom = "20";
	portraitAngle = "2";
	portraitFOV = "26";
	
	//audio
	audioList = "SEL : hotel_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 3;
   deathProp = "woodpickup goldbagpickup chest";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1";  // the location to place the death props
	
	//effects
	addGameEffect = "fire fireEffectronData 0.8 2 1.2 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 0.8 2 2 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData 2.2 -1.2 4 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 2.2 -1.2 5 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData -6.5 -1.2 7.5 " @ $Detail::Low;
	addGameEffect = "fire fireEffectronData -4.3 1.8 6.4 " @ $Detail::Low;
	addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "hotel_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_HOT01 m_civilian_HOT02 m_civilian_HOT03";
	fConstructSound = "f_civilian_HOT02 f_civilian_HOT03 f_civilian_HOT05 f_civilian_HOT06";
};

/* LUMBER MILL ------------------------------------------------------------------
-------------------------------------------------------------------------*/

// Lumber mill Datablock
datablock CCmpBuildingData(LumbermillData)
{
   hiderMax = 2;
   tenantMax = 0;
   employeeMax = 2;

   // door offset from position
   door = "-1 7";
   
   // construction building properties
   constructionProp = "5 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts"; 
   constructionProp = "0 0 45 1 ~/data/shapes/props/townProps/constructpropwood.dts"; 
   constructionProp = "-6 -4 90 0.8 ~/data/shapes/props/townProps/constructproplogs.dts " @ $Detail::Medium;
   constructionProp = "-7 2 90 0.9 ~/data/shapes/props/townProps/constructproplogs.dts"; 
   constructionProp = "1 4 0 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "2 0";
   constructionScale = 7;
   constructionTime = 20;
   constructionPresentStart = 5;
   constructionPresentStop = 18;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "6 -3 270 1 ~/data/shapes/props/townProps/destructionprop1.dts " @ $Detail::Medium;
   destructionProp = "-1 3 270 1 ~/data/shapes/props/townProps/destructionprop2.dts";
   destructionProp = "5 3 45 0.8 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "-1 -2 0 1 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "1 0";
   destructionScale = 8;
   destructionTime = 10;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 5;
   repaitWood = 12;
   
   //work information
   workUniform = "lumberjack";
   workItem = "saw 2 male_and_female";
   workItem = "Phonyhat 0 male_and_female";
   workerAI = "com_lumberjack_mill";
   workAnimation = "saw";

   // turn off building rotation
   facingDir = 0;
};

// Lumbermill Object
datablock SLGameObjData(Lumbermill)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   addCmpData = LumbermillData;
   addCmpData = LumbermillCmdData;

   shapeFile = "~/data/shapes/buildings/lumbermill.dts";
   
   // health
   healthMax = 250;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1.5";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 100;
   woodCost = 250;
   
   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "20 14";
	footprintSetRow = "0 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0";
	footprintSetRow = "1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 1 1 0 0 1 1 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "9 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "10 1 1 1 1 0 0 0 0 0 0 0 0 0 0 4 4 4 4 1 1";
	footprintSetRow = "11 1 1 1 1 0 0 0 0 0 0 0 0 0 0 4 4 4 4 1 1";
	footprintSetRow = "12 1 1 1 1 0 0 0 0 0 0 0 0 0 0 4 4 4 4 1 1";
	footprintSetRow = "13 1 1 1 1 0 0 0 0 0 0 0 0 0 0 4 4 4 4 1 1";
	footprintCenter = "6 8";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	addHotSpot = "17 12 90";
	addHotSpot = "15 2 0";
	addHotSpot = "11 2 0";

	receiveLMLighting = false;
	
   // shadow for the object
	shadowDecal = LumbermillShadowDecal;
	shadowScale = 8;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "1 .5";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "-0.5 -0.8 3.8";
	portraitRotation = "20";
	portraitHeight = "8";
	portraitZoom = "24";
	portraitAngle = "1";
	portraitFOV = "26";
	portraitImageMale = "assets/client/ui/hud/malecivlumberjack_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivlumberjack_portrait";
	
	//audio
	audioList = "SEL : lumbermill_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 2;
	deathPropMax = 3;
   deathProp = "woodpickup crate moneybagpickup woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1 -1 -1";  // the location to place the death props
   
   //effects
   addGameEffect = "produce whtsmokeEffectronData 4.2 3.6 7.8 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData -2 2 4.9 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -2 2 5.8 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 5 1.2 1.9 " @ $Detail::Low;
   addGameEffect = "fire fireEffectronData 0 0 7 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 0 0 8 " @ $Detail::High;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "lumbermill_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_LML01 m_civilian_LML02 m_civilian_LML03";
	fConstructSound = "f_civilian_LML01 f_civilian_LML02";
};

/* RANCH ------------------------------------------------------------------
-------------------------------------------------------------------------*/
// chickens
exec("~/data/shapes/props/townProps/chicken.cs");
datablock StaticShapeData(ChickenData)
{
   shapeFile = "~/data/shapes/props/townProps/chicken.dts";
   reloadProduce = false;
   animationOffset = 1;
   animationLowTime = "10";
   animationHighTime = "20";
   idleTime = "3";
};

// Pigs
datablock StaticShapeData(PigData)
{
   shapeFile = "~/data/shapes/props/townProps/pig.dts";
   reloadProduce = false;
   animationOffset = 1;
   animationLowTime = "10";
   animationHighTime = "20";
   idleTime = "3";
};

// Cattle
datablock StaticShapeData(CowData)
{
   shapeFile = "~/data/shapes/characters/cow.dts";
   reloadProduce = false;
   animationOffset = 1;
   animationLowTime = "10";
   animationHighTime = "20";
   idleTime = "3";
};

// Sheep
datablock StaticShapeData(SheepData)
{
   shapeFile = "~/data/shapes/characters/sheep.dts";
   reloadProduce = false;
   animationOffset = 1;
   animationLowTime = "10";
   animationHighTime = "20";
   idleTime = "3";
};

// Ranch Datablock
datablock CCmpBuildingData(RanchData)
{
   hiderMax = 4;
   tenantMax = 0;
   employeeMax = 4;

   // door offset from position
   door = "5 6 0";

   // default point production settings
   produce = "chicken";
   produceType = $Resource::Food;

   // chicken production
   addProduceTime = "chicken 30 0 0";
   addProduceRates = "chicken 0 3 6 8 10";
   addProduceDatablock = "chicken chickenData";
   addProducePoint = "chicken -6 -1 0";
   addProducePoint = "chicken -3 -4 0";
   addProducePoint = "chicken -4 0 0";
   addProducePoint = "chicken -8 1 0";

   // pig production
   addProduceTime = "pig 30 0 0";
   addProduceRates = "pig 0 4 8 10 12";
   addProduceDatablock = "pig PigData";
   addProducePoint = "pig -6.5 1 0";
   addProducePoint = "pig -3.5 0 0";
   addProducePoint = "pig -8 -3.5 0";

   // cow production
   addProduceTime = "cow 30 0 0";
   addProduceRates = "cow 0 5 7 10 14";
   addProduceDatablock = "cow CowData";
   addProducePoint = "cow -6.5 2 0";
   addProducePoint = "cow -2.5 0 0";
   addProducePoint = "cow -8 -4 0";
   
   // sheep production
   addProduceTime = "sheep 30 0 0";
   addProduceRates = "sheep 0 1 1 1 1";
   addProduceDatablock = "sheep SheepData";
   addProducePoint = "sheep -5 2 0";
   addProducePoint = "sheep -2.2 0 0";
   addProducePoint = "sheep -6 -3.5 0";

   // construction building properties
   constructionProp = "-2 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "4 1 45 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "-7 -1 0 1 ~/data/shapes/props/townProps/constructproplogs.dts";
   constructionProp = "3 5 0 1 ~/data/shapes/props/townProps/constructpropstump.dts";
   constructionProp = "9 -2 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "5 -4 45 1 ~/data/shapes/props/townProps/constructproptable.dts";
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "4 0";
   constructionScale = 8;
   constructionTime = 20;
   constructionPresentStart = 5;
   constructionPresentStop = 19;
   
   // building consumption information
   consumeWater = "0 4 6 8 10";
   
   // production building properties
   produceFoodCap = 5;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-1 -3 -10 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "7 -2 270 1 ~/data/shapes/props/townProps/destructionprop3.dts";
   destructionProp = "-3 3 90 1 ~/data/shapes/props/townProps/destructionprop2.dts";
   destructionProp = "5 1 270 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "-7 -3 180 1 ~/data/shapes/props/townProps/destructionprop2.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "2 -1";
   destructionScale = 8;
   destructionTime = 10;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 6;
   repaitWood = 9;

   //work information
   workUniform = "base";
   workerAI = "com_default";
   workItem = "feedpail 2 male_and_female";
   workItem = "BanditHat 0 male_and_female";
   workItem = "Rancherbandana 3 male_and_female";
   workAnimation = "feed";
   workAnimation = "feed2";
};

// Ranch Object
datablock SLGameObjData(Ranch)
{
   snapGrid = $SnapGrid::Terrain;

   addCmpData = RanchData;
   addCmpData = RanchCmdData;
   
   shapeFile = "~/data/shapes/buildings/ranch.dts";
   
   // health
   healthMax = 220;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 3";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   
	// resource requirements to build object
   goldCost = 140;
   woodCost = 180;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "24 16";
	footprintSetRow = "0 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 0 5 5 5 5 5";
	footprintSetRow = "1 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 0 5 5 5 5 5";
	footprintSetRow = "2 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 0 5 5 5 5 5";
	footprintSetRow = "3 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 0 5 5 5 5 5";
	footprintSetRow = "4 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 0 5 5 5 5 5";
	footprintSetRow = "5 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 0 5 5 5 5 5";
	footprintSetRow = "6 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 0 5 5 5 5 5";
	footprintSetRow = "7 0 0 0 0 0 0 0 0 0 8 8 8 8 8 8 8 8 8 0 5 5 5 5 5";
	footprintSetRow = "8 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5 5";
	footprintSetRow = "9 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5 5";
	footprintSetRow = "10 5 5 1 1 1 1 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5";
	footprintSetRow = "11 5 5 1 1 1 1 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5";
	footprintSetRow = "12 1 1 1 1 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 3 3";
	footprintSetRow = "13 1 1 1 1 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 3 3";
	footprintSetRow = "14 1 1 1 1 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 3 3";
	footprintSetRow = "15 1 1 1 1 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 3 3";
	footprintCenter = "16 6";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "8 " @ $Texture::Grass;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	receiveLMLighting = false;
	
   // shadow for the object
	shadowDecal = RanchShadowDecal;
	shadowScale = 10.5;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-1.8 -2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "-5 0 4.4";
	portraitRotation = "25";
	portraitHeight = "8";
	portraitZoom = "25";
	portraitAngle = "2";
	portraitFOV = "28";
	portraitImageMale = "assets/client/ui/hud/malecivrancher_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivrancher_portrait";

	addHotSpot = "11 11 180";
	addHotSpot = "7 11 180";
	addHotSpot = "3 2 270";
	addHotSpot = "3 8 270";
		
	//audio
	audioList = "SEL : ranch_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 15;
	selectionIcon = true;
	
   // Goodie death props
	deathPropMin = 2;
	deathPropMax = 3;
   deathProp = "crate woodpickup woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1";  // the location to place the death props
   
   //effects
   addGameEffect = "fire fireEffectronData 4.1 4.7 6.6 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 4.1 4.7 7.4 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 7.2 0.4 4.9 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 7.2 0.4 5.8 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 3.6 -2.8 7.3 " @ $Detail::Low;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   addGameEffect = "plague farmEffectronData 0 0 2 " @ $Detail::Low;

	//Naming
	nameKey = "ranch_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_RAN01 m_civilian_RAN02 m_civilian_RAN03 m_civilian_RAN04 m_civilian_RAN05 m_civilian_RAN06";
	fConstructSound = "f_civilian_RAN01 f_civilian_RAN02 f_civilian_RAN03 f_civilian_RAN04 f_civilian_RAN05";
};

/* SALOON -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Saloon Datablock
datablock CCmpBuildingData(SaloonData)
{
   hiderMax = 5;
   tenantMax = 0;
   employeeMax = 2;
   
   // door offset from position
   door = "0 5 0";
   
   buildHappiness = "5 3 2 -4 -8 -10";
   happinessString = "Saloon Entertainment";

   // construction building properties
   constructionProp = "0 5 90 0.9 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "4 -2 45 1 ~/data/shapes/props/townProps/constructpropwood.dts"; 
   constructionProp = "0 0 45 1 ~/data/shapes/props/townProps/constructproptable.dts " @ $Detail::Medium;
   constructionProp = "2 3 0 0.9 ~/data/shapes/props/townProps/barrel.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionScale = 7;
   constructionOffset = "0 0";
   constructionTime = 15;
   constructionPresentStart = 3;
   constructionPresentStop = 14;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-5 0 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "-4 2 0 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "1 0 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "2 -1 270 1 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 6;
   destructionTime = 8;

   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 4;
   repaitWood = 7;

   //work information
   workAnimation = "washmug";
   workUniform = "bartender";
   workerAI = "com_Saloon";
   workItem = "Mug 2 male_and_female";
   workItem = "Phonyhat 0 male";
   workItem = "Bonnet 0 female";
   
};

// Saloon Object
datablock SLGameObjData(Saloon)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   // Components
   addCmpData = SaloonData;
   addCmpData = SaloonCmdData;
   
   shapeFile = "~/data/shapes/buildings/saloon.dts";
   
   // health
   healthMax = 220;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 80;
   woodCost = 150;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "12 16";
	footprintSetRow = "0 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "1 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "2 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "3 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "4 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "5 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "6 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "7 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "8 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "9 3 3 0 0 0 4 4 0 0 0 3 3";
	footprintSetRow = "10 3 3 3 3 4 4 4 4 3 3 3 3";
	footprintSetRow = "11 3 3 3 3 4 4 4 4 3 3 3 3";
	footprintSetRow = "12 1 1 1 1 4 4 4 4 1 1 1 1";
	footprintSetRow = "13 1 1 1 1 4 4 4 4 1 1 1 1";
   footprintSetRow = "14 1 1 1 1 4 4 4 4 1 1 1 1";
   footprintSetRow = "15 1 1 1 1 4 4 4 4 1 1 1 1";
	footprintCenter = "6 6";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	// shadow for the object
	shadowDecal = SaloonShadowDecal;
	shadowScale = 5.3;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 2.6";
	portraitRotation = "20";
	portraitHeight = "8";
	portraitZoom = "25";
	portraitAngle = "2";
	portraitFOV = "27";
	portraitImageMale = "assets/client/ui/hud/malecivclerk_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivclerk_portrait";

	addHotSpot = "3 11 315";
	addHotSpot = "9 11 30";
	
   aicmd_tar = "cmd_saloon";
   aicmd     = "";
	
	//audio
	audioList = "SEL : saloon_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 2;
	deathPropMax = 2;
   deathProp = "woodpickup crate woodpickup";    // new prop that replaces old prop
   deathLocation = "-2 -2 1 1 -1 -1";  // the location to place the death props
   
   //effects
   addGameEffect = "fire smallfireEffectronData 0 2.1 3.5 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 0 2.1 4.5 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 3.2 -2 6.2 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 3.2 -2 7 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData -2.7 1.8 9.2 " @ $Detail::Low;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "saloon_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_SOO01 m_civilian_SOO02 m_civilian_SOO03 m_civilian_SOO04";
	fConstructSound = "f_civilian_SOO01 f_civilian_SOO02 f_civilian_SOO03 f_civilian_SOO04";
};

/* GENERAL STORE -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// General store Datablock
datablock CCmpBuildingData(GeneralData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 2;
   
   // door offset from position
   door = "0 6 0";
   
   /*
   produceTime = "30";
   produceGold = "0 2 5";
   */

   // construction building properties
   constructionProp = "-5 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";
   constructionProp = "-2 5 35 1 ~/data/shapes/props/townProps/constructproptable.dts";
   constructionProp = "1 -1 30 1 ~/data/shapes/props/townProps/constructpropwood.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionScale = 7;
   constructionOffset = "0 0";
   constructionTime = 15;
   constructionPresentStart = 3;
   constructionPresentStop = 14;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "3 -2 0 0.7 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "-4 2 0 0.7 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "0 -1 270 0.8 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionScale = 6;
   destructionOffset = "0 0";
   destructionTime = 10;
   
   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 5;
   repaitWood = 5;
   
   //work information
   workUniform = "bartender";
   workerAI = "com_default";
   workItem = "Broom 2 male_and_female";                       
   workItem = "Phonyhat 0 male";
   workItem = "Bonnet 0 female";
   workAnimation = "sweep";

};

// General store Object
datablock SLGameObjData(General)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   // Components
   addCmpData = GeneralData;
   addCmpData = GeneralCmdData;
   
   shapeFile = "~/data/shapes/buildings/generalstore.dts";
   
   // health
   healthMax = 200;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   canDamage = true;

   // resource requirements to build object
   goldCost = 100;
   woodCost = 100;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "12 16";
	footprintSetRow = "0 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "1 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "2 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "3 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "4 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "5 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "6 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "7 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "8 3 3 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "9 3 3 0 0 0 4 4 0 0 0 3 3";
	footprintSetRow = "10 3 3 3 3 4 4 4 4 3 3 3 3";
	footprintSetRow = "11 3 3 3 3 4 4 4 4 3 3 3 3";
	footprintSetRow = "12 1 1 1 1 4 4 4 4 1 1 1 1";
	footprintSetRow = "13 1 1 1 1 4 4 4 4 1 1 1 1";
   footprintSetRow = "14 1 1 1 1 4 4 4 4 1 1 1 1";
   footprintSetRow = "15 1 1 1 1 4 4 4 4 1 1 1 1";
	footprintCenter = "6 6";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	
	// shadow for the object
	shadowDecal = GeneralstoreShadowDecal;
	shadowScale = 5.2;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = ".5 0 3.2";
	portraitRotation = "21";
	portraitHeight = "8";
	portraitZoom = "21";
	portraitAngle = "3";
	portraitFOV = "26";
	portraitImageMale = "assets/client/ui/hud/malecivclerk_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivclerk_portrait";

	addHotSpot = "3 11 315";
	addHotSpot = "9 11 30";
	
	//audio
	audioList = "SEL : generalstore_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 30;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 2;
   deathProp = "woodpickup goldbagpickup crate";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1";  // the location to place the death props
	
	//effects
	addGameEffect = "fire fireEffectronData 2.3 -2.4 5.5 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 2.3 -2.4 6.5 " @ $Detail::High;
	addGameEffect = "fire smallfireEffectronData -1 2.3 1.3 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData -1 2.3 2.3 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData -2.6 1.6 8.2 " @ $Detail::Low;
	addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "generalstore_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_GST01 m_civilian_GST02 m_civilian_GST03 m_civilian_GST04";
	fConstructSound = "f_civilian_GST01 f_civilian_GST02 f_civilian_GST03 f_civilian_GST04 f_civilian_GST05";
};

/* WELL -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Well Datablock
datablock CCmpBuildingData(WellData)
{
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 0;
   
   // door offset from position
   door = "1 3 0";
   
   // construction building properties
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 3.5;
   constructionTime = 8;
   constructionPresentStart = 2;
   constructionPresentStop = 7;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // production building properties
   produceTime = 30;
   produceWater = "10";
   produceWaterCap = 8;
   
	// destruction building properties

   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 3.5;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 12;
   repairGold = 3;
   repaitWood = 2;

   flammable = false;
   canLocate = false;
   
   // turn off building rotation
   facingDir = 0;
};

// well store Object
datablock SLGameObjData(well)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";

   // Components
   addCmpData = wellData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/well.dts";
   
   // health
   healthMax = 150;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 50;
   woodCost = 30;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "6 6";
	footprintSetRow = "0 1 1 1 1 1 1";
	footprintSetRow = "1 1 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 1";
	footprintSetRow = "5 1 1 1 1 1 1";
	footprintCenter = "3 3";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	
	smallMinimapIcon = true;

	// shadow for the object
	shadowDecal = WellShadowDecal;
	shadowScale = 3.2;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 5.5";
	portraitRotation = "55";
	portraitHeight = "8";
	portraitZoom = "12";
	portraitAngle = "5";
	portraitFOV = "25";

	//audio
	audioList = "SEL : well_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 10;
	selectionIcon = true;
	
	//effects
	addGameEffect = "construct constructsmEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "well_name";
	
	// Construction finished sounds
	constructSoundChance = "80";
	mConstructSound = "m_civilian_WEL01 m_civilian_WEL02 m_civilian_WEL03";
	fConstructSound = "f_civilian_WEL01 f_civilian_WEL02 f_civilian_WEL03";
};

/* WATER TOWER -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Water Tower Datablock
datablock CCmpBuildingData(watertowerData)
{
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 0;

   // door offset from position
   door = "1 3 0";

   // construction building properties
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 -2 0 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 4;
   constructionTime = 10;
   constructionPresentStart = 2;
   constructionPresentStop = 8;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // production building properties
   produceWaterCap = 15;

   // destruction building properties
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "-1 1 45 0.7 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructionProp = "2 -1 175 0.7 ~/data/shapes/props/townProps/destructionprop2.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 4;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 10;
   repairGold = 2;
   repaitWood = 5;
   
   flammable = false;
   
   // turn off building rotation
   facingDir = 0;
};

// water tower store Object
datablock SLGameObjData(watertower)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";

   // Components
   addCmpData = watertowerData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/watertower.dts";
   
   // health
   healthMax = 80;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 2";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 20;
   woodCost = 60;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 0 0 0 0 1 1";
	footprintSetRow = "3 1 1 0 0 0 0 1 1";
	footprintSetRow = "4 1 1 0 0 0 0 1 1";
	footprintSetRow = "5 1 1 0 0 0 0 1 1";
	footprintSetRow = "6 1 1 1 1 1 1 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	
	smallMinimapIcon = true;

	// shadow for the object
	shadowDecal = WatertowerShadowDecal;
	shadowScale = 3;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = ".5 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 2";
	portraitRotation = "30";
	portraitHeight = "8";
	portraitZoom = "21";
	portraitAngle = "3";
	portraitFOV = "25";
	
	//audio
	audioList = "SEL : watertower_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 15;
	selectionIcon = true;

	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 1;
   deathProp = "woodpickup";    // new prop that replaces old prop
   deathLocation = " 1 1";  // the location to place the death props
	
	//effects
	addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "watertower_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_WTW01 m_civilian_WTW02";
	fConstructSound = "f_civilian_WTW01 f_civilian_WTW02";
};

/* SHERIFF OFFICE ---------------------------------------------------------
-------------------------------------------------------------------------*/

// Sheriffs Office Datablock
datablock CCmpBuildingData(SheriffsOfficeData)
{
   hiderMax = 4;
   tenantMax = 0;
   employeeMax = 0;
   
   // door offset from position
   door = "5 5 0";
   
   // construction building properties
   constructionProp = "3 3 30 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 -2 0 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructionProp = "-3 0 0 1 ~/data/shapes/props/townProps/barrel.dts " @ $Detail::Medium;
   constructionProp = "-4 2 0 1 ~/data/shapes/props/townProps/box.dts " @ $Detail::Medium;
   constructionProp = "-2 -5 0 1 ~/data/shapes/props/townProps/constructpropbricks.dts";
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 8;
   constructionTime = 25;
   constructionPresentStart = 4;
   constructionPresentStop = 24;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-8 -3 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "-2 -3 0 1 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "0 0 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "0 -3 270 1 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "-3 -1";
   destructionScale = 9;
   destructionTime = 10;
   
   // repair info
   repairTime = 3;
   repairAmount = 16;
   repairGold = 10;
   repaitWood = 7;
   
   // turn off building rotation
   facingDir = 0;
};

// Sheriff Office Object
datablock SLGameObjData(SheriffsOffice)
{
   snapGrid = $SnapGrid::Terrain;
   
	addCmpData = SheriffsOfficeData;
   addCmpData = SheriffsOfficeCmpData;

	// health
   healthMax = 310;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 2";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 220;
   woodCost = 200;
   
	shapeFile = "~/data/shapes/buildings/sheriffsOffice.dts";

   //footprint
   footprintGrid = $SnapGrid::object;
	footprintSize = "24 20";
	footprintSetRow = "0 1 1 1 1 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 3 3";
	footprintSetRow = "1 1 1 1 1 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 3 3";
	footprintSetRow = "2 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "3 1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "5 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "6 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "7 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "8 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "9 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "10 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "11 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "12 4 4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "13 4 4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 3 3";
	footprintSetRow = "14 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 3 3";
	footprintSetRow = "15 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 3 3";
	footprintSetRow = "16 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 3 3";
	footprintSetRow = "17 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 1 1 3 3";
	footprintSetRow = "18 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 3 3";
	footprintSetRow = "19 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 3 3";
	footprintCenter = "14 8";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;
	receiveLMLighting = false;
	
   // shadow for the object
	shadowDecal = SheriffShadowDecal;
	shadowScale = 7.2;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-1.8 -.5";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 3.4";
	portraitRotation = "25";
	portraitHeight = "8";
	portraitZoom = "25";
	portraitAngle = "2";
	portraitFOV = "21";
	
	//audio
	audioList = "SEL : sheriffsoffice_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 2;
	deathPropMax = 3;
   deathProp = "goldbagpickup woodpickup crate";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 -1 -1";  // the location to place the death props

	//effects
	addGameEffect = "fire fireEffectronData 1.3 1 6 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 1.3 1 7 " @ $Detail::High;
	addGameEffect = "fire smallfireEffectronData -1.8 1.5 1.6 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData -1.8 1.5 2.6 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData -6 1 6.1 " @ $Detail::Low;
	addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "sheriffsoffice_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_SSO01 m_civilian_SSO02 m_civilian_SSO03 m_civilian_SSO04 m_civilian_SSO05";
	fConstructSound = "f_civilian_SSO01 f_civilian_SSO02 f_civilian_SSO03 f_civilian_SSO04";
};

/* WATCH TOWER -------------------------------------------------------------
-------------------------------------------------------------------------*/

// WATCH TOWER Datablock
datablock CCmpBuildingData(WatchtowerData)
{
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 0;
   
   // door offset from position
   door = "0 4 0";
   
   // construction building properties
   constructionProp = "-1 2 0 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 0 0 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = "3.5";
   constructionTime = 10;
   constructionPresentStart = 4;
   constructionPresentStop = 9;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-1 1 0 0.7 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 4;
   destructionTime = 5;

   // repair info
   repairTime = 3;
   repairAmount = 10;
   repairGold = 6;
   repaitWood = 8;
   
   flammable = false;
};

// Watchtower Object
datablock SLGameObjData(Watchtower)
{
   snapGrid = $SnapGrid::Object;
   addCmpData = WatchtowerData;
   addCmpData = BaseCmdData;

   // health
   healthMax = 100;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1.5";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   
   // resource requirements to build object
   goldCost = 100;
   woodCost = 140;
   
   shapeFile = "~/data/shapes/props/townprops/watchtower.dts";

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 0 0 0 0 1 1";
	footprintSetRow = "3 1 1 0 0 0 0 1 1";
	footprintSetRow = "4 1 1 0 0 0 0 1 1";
	footprintSetRow = "5 1 1 0 0 0 0 1 1";
	footprintSetRow = "6 1 1 1 1 1 1 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";
	
	smallMinimapIcon = true;

   // shadow for the object
	shadowDecal = WatchTowerShadowDecal;
	shadowScale = 3.5;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 1";
	portraitRotation = "25";
	portraitHeight = "5";
	portraitZoom = "20";
	portraitAngle = "2";
	portraitFOV = "25";
	
	//audio
	audioList = "SEL : watchtower_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 25;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 2;
   deathProp = "crate woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 1 1";  // the location to place the death props
	
	//effects
	addGameEffect = "construct constructsmEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "watchtower_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_WTO01 m_civilian_WTO02";
	fConstructSound = "f_civilian_WTO01 f_civilian_WTO03";
};

/* WOODHUT -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Woodhut Datablock
datablock CCmpTargetBuildingData(WoodhutData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 3;
   
   // door offset from position
   door = "3 3 0";

   // construction building properties
   constructionProp = "0 0 25 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 -2 45 1 ~/data/shapes/props/townProps/constructpropstump.dts";
   constructionProp = "-5 1 0 1 ~/data/shapes/props/townProps/constructproplogs.dts";
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 1";
   constructionScale = 7;
   constructionTime = 10;
   constructionPresentStart = 2;
   constructionPresentStop = 8;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // production building properties
   produceTime = 30;
   produceWood = "0 12 17 22";
   produceWaterCap = 0;
   produceFoodCap = 0;

   // destruction building properties
   destructionProp = "-3 0 0 1 ~/data/shapes/props/townProps/destructionprop1.dts";
   destructionProp = "-2 2 270 0.8 ~/data/shapes/props/townProps/destructionprop2.dts";
   destructionProp = "2 2 0 0.7 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 6;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 4;
   repaitWood = 1;
   
   // tree data, for the trees that can be chopped down
   addTargetDatablock = appletree;
   addTargetDatablock = PineTree;
   addTargetDatablock = oaktree;
   addTargetDatablock = Joshuatree;
   addTargetDatablock = deadoaktree;
	targetRadius = 38;

   //work information
   workUniform = "lumberjack";
   workItem = "Axe 2 male_and_female";
   workItem = "Phonyhat 0 male_and_female";
   workAnimation = "chopwood";
   workerAI = "com_lumberjack_woodhut";
   
   // turn off building rotation
   facingDir = 0;
};

// Woodhut Object
datablock SLGameObjData(Woodhut)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";
   //creationAngle = "90"; // use when yaw changes
   
   // Components
   addCmpData = WoodhutData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/woodhut.dts";
   
   // health
   healthMax = 120;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 2.5";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 60;
   woodCost = 20;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 0 0 0 0 0 0 0 0";
	footprintSetRow = "1 0 0 0 0 0 0 0 0";
	footprintSetRow = "2 0 0 0 0 0 0 0 0";
	footprintSetRow = "3 0 0 0 0 0 0 0 0";
	footprintSetRow = "4 1 1 1 1 0 0 0 0";
	footprintSetRow = "5 1 1 1 1 0 0 0 0";
	footprintSetRow = "6 1 1 1 1 0 0 0 0";
	footprintSetRow = "7 1 1 1 1 0 0 0 0";
	footprintCenter = "4 4";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;

	// shadow for the object
	shadowDecal = WoodhutShadowDecal;
	shadowScale = 5.7;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = -180;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 3.9";
	portraitRotation = "56";
	portraitHeight = "8";
	portraitZoom = "24";
	portraitAngle = "2";
	portraitFOV = "25";
	portraitImageMale = "assets/client/ui/hud/malecivlumberjack_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivlumberjack_portrait";

	//audio
	audioList = "SEL : woodhut_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 18;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 2;
	deathPropMax = 2;
   deathProp = "woodpickup woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2";  // the location to place the death props
	
	//effects
	addGameEffect = "fire smallfireEffectronData -1.5 3 2.4 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData -1.5 3 3.4 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData 2 -2 5.2 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 2 -2 5.2 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData -2.6 0 5.7 " @ $Detail::Low;
	addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "woodhut_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_WOO01 m_civilian_WOO02";
	fConstructSound = "f_civilian_WOO01 f_civilian_WOO02";
};

/* OUTHOUSE -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Outhouse Datablock
datablock CCmpBuildingData(OuthouseData)
{
   hiderMax = 1;
   tenantMax = 0;
   employeeMax = 0;
   
   // door offset from position
   door = "0 2 0";

   buildHappiness = "1 1 1 1";
   happinessString = "Outhouse Relief";

   // construction building properties
   constructionProp = "0 0 0 0.8 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 -2 0 0.8 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 3.5;
   constructionTime = 6;
   constructionPresentStart = 2;
   constructionPresentStop = 5;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 3.5;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 10;
   repairGold = 2;
   repaitWood = 3;
   

};

// Outhouse Object
datablock SLGameObjData(Outhouse)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";
   
   // Components
   addCmpData = OuthouseData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/outhouse.dts";

   // health
   healthMax = 60;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 20;
   woodCost = 40;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "6 6";
	footprintSetRow = "0 1 1 1 1 1 1";
	footprintSetRow = "1 1 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 1";
	footprintSetRow = "5 1 1 1 1 1 1";
	footprintCenter = "3 3";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	
	smallMinimapIcon = true;

	// shadow for the object
	shadowDecal = OuthouseShadowDecal;
	shadowScale = 1.9;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = -180;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = ".5 -0.2 5.8";
	portraitRotation = "18";
	portraitHeight = "8";
	portraitZoom = "10";
	portraitAngle = "3";
	portraitFOV = "26";
	
	//audio
	audioList = "SEL : outhouse_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 10;
	selectionIcon = true;
	
	//effect
   addGameEffect = "construct constructsmEffectronData 0 0 1.5 " @ $Detail::Low;
   addGameEffect = "fire fireEffectronData -1.2 1.0 2 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -1.2 1.0 2.8 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 0.78 -0.48 3.7 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData .78 -0.48 4.2 " @ $Detail::High;

	//Naming
	nameKey = "outhouse_name";
	
	// Construction finished sounds
	constructSoundChance = "80";
	mConstructSound = "m_civilian_OUT01";
	fConstructSound = "f_civilian_OUT01 f_civilian_OUT02 f_civilian_OUT03";
};

/* Shack -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Shack Datablock
datablock CCmpBuildingData(ShackData)
{
   hiderMax = 1;
   tenantMax = 1;
   employeeMax = 0;
   
   // door offset from position
   door = "0 2 0";

   // construction building properties
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 -2 0 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = smConstructionDecal;
   constructEffect = smConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 4;
   constructionTime = 8;
   constructionPresentStart = 2;
   constructionPresentStop = 6;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "0 0 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructDecal = smDestructionDecal;
   destructEffect = smDestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 3.5;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 2;
   repaitWood = 4;
   
   // respawn time
   respawnTime = 45;
   
   // housing values
   housingOffset = 1;
   
   buildHappiness = "-1 -1 -1 -1 -1 -1";
   happinessString = "Shack Ruggedness";
};

// Shack Object
datablock SLGameObjData(Shack)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";
   
   // Components
   addCmpData = ShackData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/shack.dts";
   
   // health
   healthMax = 80;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 2";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 15;
   woodCost = 30;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 1 1 1 1 1 1 1 1";
	footprintSetRow = "1 1 1 1 1 1 1 1 1";
	footprintSetRow = "2 1 1 0 0 0 0 1 1";
	footprintSetRow = "3 1 1 0 0 0 0 1 1";
	footprintSetRow = "4 1 1 0 0 0 0 1 1";
	footprintSetRow = "5 1 1 0 0 0 0 1 1";
	footprintSetRow = "6 1 1 1 1 1 1 1 1";
	footprintSetRow = "7 1 1 1 1 1 1 1 1";
	footprintCenter = "4 4";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;

	// shadow for the object
	shadowDecal = ShackShadowDecal;
	shadowScale = 2.6;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 -.4";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 5.7";
	portraitRotation = "35";
	portraitHeight = "8";
	portraitZoom = "12";
	portraitAngle = "1";
	portraitFOV = "25";
	
	//audio
	audioList = "SEL : shack_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 15;
	smallMinimapIcon = true;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 0;
	deathPropMax = 1;
   deathProp = "woodpickup";    // new prop that replaces old prop
   deathLocation = "1 1";  // the location to place the death props
	
	//effect
	addGameEffect = "fire FireEffectronData -1.19 1.53 0.78 " @ $Detail::Low;
   addGameEffect = "fire FireEffectronData -0.43 0.06 2.5 " @ $Detail::Low;
   addGameEffect = "fire FireEffectronData 0.7 0.7 1.25 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -0.43 0.06 3.1 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 0.7 0.7 2.25 " @ $Detail::Low;
   addGameEffect = "construct constructsmEffectronData 0 0 1.5 " @ $Detail::Low;

	//Naming
	nameKey = "shack_name";
	
	// Construction finished sounds
	constructSoundChance = "80";
	mConstructSound = "m_civilian_SHA01 m_civilian_SHA02 m_civilian_SHA03 m_civilian_SHA04";
	fConstructSound = "f_civilian_SHA01 m_civilian_SHA02";
};

/* Smokehouse -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Smokehouse Datablock
datablock CCmpBuildingData(SmokehouseData)
{
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 1;

   // door offset from position
   door = "0 4 0";

   buildHappiness = "2 1";
   happinessString = "Smokehouse Storage";

   // construction building properties
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "2 -2 0 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 4;
   constructionTime = 15;
   constructionPresentStart = 2;
   constructionPresentStop = 14;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "0 0 45 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "-1 -1 0 0.6 ~/data/shapes/props/townProps/destructionprop3.dts " @ $Detail::Medium;
   destructionProp = "2 1 0 0.6 ~/data/shapes/props/townProps/destructionprop2.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 -1";
   destructionScale = 5;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 15;
   repairGold = 6;
   repaitWood = 8;
   
   //work information
   workUniform = "Blacksmith";
   workerAI = "com_Smokehouse"; 
   workItem = "Pannerhat 0 male_and_female";   

};

// Smokehouse Object
datablock SLGameObjData(Smokehouse)
{
   snapGrid = $SnapGrid::Object;
   objTileOffset = "0 0";

   // Components
   addCmpData = SmokehouseData;
   addCmpData = BaseCmdData;
   
   shapeFile = "~/data/shapes/buildings/smokehouse.dts";

   // health
   healthMax = 150;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 80;
   woodCost = 100;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 10";
	footprintSetRow = "0 1 0 0 0 0 0 0 0 0 1";
	footprintSetRow = "1 1 0 0 0 0 0 0 0 0 1";
	footprintSetRow = "2 1 0 0 0 0 0 0 0 0 1";
	footprintSetRow = "3 1 0 0 0 0 0 0 0 0 1";
	footprintSetRow = "4 1 0 0 0 0 0 0 0 0 1";
	footprintSetRow = "5 1 0 0 0 0 0 0 0 0 1";
	footprintSetRow = "6 1 0 0 0 0 0 0 0 0 1";
	footprintSetRow = "7 1 0 0 0 0 0 0 0 0 1";
	footprintCenter = "4 5";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;

	// shadow for the object
	shadowDecal = SmokehouseShadowDecal;
	shadowScale = 4.1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-0.6 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;

	portraitOffset = "0 0.5 4.1";
	portraitRotation = "20";
	portraitHeight = "8";
	portraitZoom = "20";
	portraitAngle = "2";
	portraitFOV = "25";
	portraitImageMale = "assets/client/ui/hud/malecivblacksmith_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivblacksmith_portrait";
	
	addHotSpot = "2 9 0";
	
	//audio
	audioList = "SEL : smokehouse_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 10;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 2;
   deathProp = "crate woodpickup";    // new prop that replaces old prop
   deathLocation = "2 2 1 1";  // the location to place the death props
	
	//effects
	addGameEffect = "produce WhtsmokeEffectronData 0 0 7 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData 2.4 1 4 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData 2.4 1 5 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData 0 2 6.4 " @ $Detail::Low;
	addGameEffect = "construct constructsmEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "smokehouse_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_SMO01 m_civilian_SMO02 m_civilian_SMO03 m_civilian_SMO04 m_civilian_SMO05";
	fConstructSound = "f_civilian_SMO01 f_civilian_SMO02 f_civilian_SMO03 f_civilian_SMO04";
};


/* TOWN HALL--------------------------------------------------------------
-------------------------------------------------------------------------*/

// Shack Datablock
datablock CCmpBuildingData(TownHallData)
{
   hiderMax = 1;
   employeeMax = 1;

   // door offset from position
   door = "7 7 0";

   // construction building properties
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/constructpropwood.dts";
   constructionProp = "-4 -4 0 1 ~/data/shapes/props/townProps/constructpropbricks.dts";
   constructionProp = "2 6 90 1 ~/data/shapes/props/townProps/constructpropschaffold.dts " @ $Detail::Medium;
   constructionProp = "6 0 0 1 ~/data/shapes/props/townProps/constructpropschaffold.dts";

   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 10;
   constructionTime = 30;
   constructionPresentStart = 4;
   constructionPresentStop = 28;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // production building properties
   produceTime = 30;
   taxValues = "0 1 2";
   buildHappiness = "5";
   happinessString = "Town Hall Order";

   // destruction building properties
   destructionProp = "0 5 0 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "6 -3 0 0.6 ~/data/shapes/props/townProps/destructionprop1.dts " @ $Detail::Medium;
   destructionProp = "-4 -3 0 0.6 ~/data/shapes/props/townProps/destructionprop3.dts";

   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 10;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 18;
   repairGold = 10;
   repaitWood = 11;
   
   //work information
   workUniform = "banker";
   workerAI = "com_Townhall";
   workItem = "mayorhat 0 male_and_female";
   workItem = "mayorsash 3 male_and_female";
   workAnimation = "tiphat";
   
   // turn off building rotation
   facingDir = 0;
};

// Town Hall
datablock SLGameObjData(TownHall)
{
   snapGrid = $SnapGrid::terrain;
   objTileOffset = "0 0";

   // Components
   addCmpData = TownHallData;
   addCmpData = TownhallCmdData;
   
   shapeFile = "~/data/shapes/buildings/townhall.dts";
   
   // health
   healthMax = 400;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 300;
   woodCost = 350;

  //footprint
   footprintGrid = $SnapGrid::object;
	footprintSize = "24 22";
	footprintSetRow = "0 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "1 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "2 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "3 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "4 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "5 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "6 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "7 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "8 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "9 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "10 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "11 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "12 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "13 4 4 4 4 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "14 4 4 4 4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "15 4 4 4 4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "16 4 4 4 4 4 4 4 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0";
	footprintSetRow = "17 4 4 4 4 4 4 4 4 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "18 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4";
	footprintSetRow = "19 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4";
	footprintSetRow = "20 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4";
	footprintSetRow = "21 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4";
	footprintCenter = "10 8";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
   bindFootprintTexture = "1 " @ $Texture::Construction;
	bindFootprintTexture = "4 " @ $Texture::Road;

	// shadow for the object
	shadowDecal = TownhallShadowDecal;
	shadowScale = 9.8;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 -0.5 2";
	portraitRotation = "25";
	portraitHeight = "8";
	portraitZoom = "29";
	portraitAngle = "2";
	portraitFOV = "26";
	portraitImageMale = "assets/client/ui/hud/malecivbanker_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivbanker_portrait";

	addHotSpot = "10 18 0";
	addHotSpot = "20 6 355";
	addHotSpot = "18 15 315";

	//audio
	audioList = "SEL : townhall_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";

   sightRange = 25;
   selectionIcon = true;
   
    // Goodie death props
	deathPropMin = 2;
	deathPropMax = 4;
   deathProp = "chest moneybagpickup woodpickup crate";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1 -1 -1";  // the location to place the death props
   
   //effects
   addGameEffect = "produce whtsmokeEffectronData -4.9 1.7 10.8 " @ $Detail::High;
   addGameEffect = "produce whtsmokeEffectronData 1.7 -4.4 10.8 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 5.3 -0.7 5 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData 5.3 -0.7 6 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData -1.8 3.2 7.8 " @ $Detail::Low;
   addGameEffect = "fire smokeEffectronData -1.8 3.2 8.8 " @ $Detail::High;
   addGameEffect = "fire fireEffectronData 2.7 2.7 10 " @ $Detail::Low;
   addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "townhall_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_THO01 m_civilian_THO02 m_civilian_THO03 m_civilian_THO04";
	fConstructSound = "f_civilian_THO01 f_civilian_THO02 f_civilian_THO03 f_civilian_THO04 f_civilian_THO05";
};

/* TRADING POST -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Trading Post Datablock
datablock CCmpBuildingData(TradingpostData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 1;
   
   // door offset from position
   door = "0 6 0";

   buildHappiness = "2 1";
   happinessString = "Trading Post Commerce";

   // construction building properties
   constructionProp = "-5 0 0 1 ~/data/shapes/props/townProps/constructproplogs.dts " @ $Detail::Medium;
   constructionProp = "2 -2 0 1 ~/data/shapes/props/townProps/constructpropstump.dts " @ $Detail::Medium;
   constructionProp = "0 3 0 1 ~/data/shapes/props/townProps/constructpropwood.dts"; 
   constructionProp = "0 -4 90 1 ~/data/shapes/props/townProps/constructpropschaffold.dts"; 
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 5;
   constructionTime = 20;
   constructionPresentStart = 3;
   constructionPresentStop = 18;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties
   destructionProp = "-3 2 45 0.6 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionProp = "-4 -3 0 0.6 ~/data/shapes/props/townProps/destructionprop3.dts";
   destructionProp = "2 1 0 0.6 ~/data/shapes/props/townProps/destructionprop2.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "-1 -1";
   destructionScale = 7;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 10;
   repairGold = 10;
   repaitWood = 10;
   
   //work information
   workUniform = "base";
   workItem = "Banjo 3 male";
   workItem = "Banjo2 3 female";
   workItem = "Pothat 0 male";
   workItem = "Pothatfemale 0 female";
   workAnimation = "banjoplay";
};

// Trading post Object
datablock SLGameObjData(Tradingpost)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";
   //creationAngle = "90"; // use when yaw changes
   
   // Components
   addCmpData = TradingpostData;
   addCmpData = TradingpostCmdData;
   
   shapeFile = "~/data/shapes/buildings/tradingpost.dts";
   
   // health
   healthMax = 150;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 1";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 180;
   woodCost = 180;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "16 16";
	footprintSetRow = "0 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "1 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "2 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "3 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "4 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "5 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "6 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "7 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "8 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "9 3 3 0 0 0 0 0 0 0 0 0 0 0 0 3 3";
	footprintSetRow = "10 3 3 3 3 4 4 4 4 3 3 3 3 3 3 3 3";
	footprintSetRow = "11 3 3 3 3 4 4 4 4 3 3 3 3 3 3 3 3";
	footprintSetRow = "12 1 1 1 1 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "13 1 1 1 1 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "14 1 1 1 1 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintSetRow = "15 1 1 1 1 4 4 4 4 4 4 4 4 1 1 1 1";
	footprintCenter = "10 6";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	bindFootprintTexture = "4 " @ $Texture::Road;

	// shadow for the object
	shadowDecal = TradingpostShadowDecal;
	shadowScale = 7;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-1 -1.8";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "1 1 3.6";
	portraitRotation = "18";
	portraitHeight = "8";
	portraitZoom = "21";
	portraitAngle = "3";
	portraitFOV = "25";
	portraitImageMale = "assets/client/ui/hud/malecivtrader_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivtrader_portrait";
	
   addHotSpot = "3 10 315";

	//audio
	audioList = "SEL : tradingpost_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
	
	 // Goodie death props
	deathPropMin = 1;
	deathPropMax = 3;
   deathProp = "crate woodpickup crate moneybagpickup";    // new prop that replaces old prop
   deathLocation = "2 2 -2 -2 1 1";  // the location to place the death props
	
	//effects
	addGameEffect = "fire fireEffectronData -1.1 3.6 5 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData -1.1 3.6 6 " @ $Detail::High;
	addGameEffect = "fire fireEffectronData 1 -2 5.9 " @ $Detail::Low;
	addGameEffect = "fire fireEffectronData -3 -0.7 6 " @ $Detail::Low;
	addGameEffect = "fire smokeEffectronData -3 -0.7 7 " @ $Detail::High;
	addGameEffect = "construct constructEffectronData 0 0 1.5 " @ $Detail::High;
   
	//Naming
	nameKey = "tradingpost_name";
	
	// Construction finished sounds
	constructSoundChance = "100";
	mConstructSound = "m_civilian_TPO01 m_civilian_TPO02 m_civilian_TPO03 m_civilian_TPO04";
	fConstructSound = "f_civilian_TPO01 f_civilian_TPO03 f_civilian_TPO04";
};

/* TRAIN STATION -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Train station Datablock
datablock CCmpBuildingData(trainstationData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 1;
   
   // door offset from position
   door = "-2 8 0";

   // construction building properties
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 2;
   constructionTime = 6;
   constructionPresentStart = 2;
   constructionPresentStop = 6;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // destruction building properties

   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 2;
   destructionTime = 6;
   
   // production information
   produceTime = 10;
   produceSelect = true;
   produceGold = "0 30 45";
   produceWood = "0 25 40";
   produceFood = "0 20 30";
   
   // repair info
   repairTime = 3;
   repairAmount = 20;
   repairGold = 10;
   repaitWood = 10;
   
   flammable = false;
   vulnerable = false;
   
   //work information
   workUniform = "banker";
   workerAI = "com_default";
   workItem = "Clipboard 2 male_and_female";
   workItem = "Conductorhat 0 male_and_female";
   workAnimation = "lookclipboard";
};

// trainstation Object
datablock SLGameObjData(trainstation)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";
   
   // Components
   addCmpData = trainstationData;
   addCmpData = TrainStationCmdData;
   
   shapeFile = "~/data/shapes/buildings/trainstation.dts";

   // health
   healthMax = 400;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   canDamage = false;

   // resource requirements to build object
   goldCost = 250;
   woodCost = 250;

   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "24 16";
	footprintSetRow = "0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "2 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "3 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "4 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "5 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "6 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "7 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "8 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "9 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "10 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "11 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "12 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "13 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "14 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "15 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintCenter = "12 8";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;

        // shadow for the object
	shadowDecal = TrainStationShadowDecal;
	shadowScale = 11.5;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-1.2 -2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0.5 1.1";
	portraitRotation = "-18";
	portraitHeight = "8";
	portraitZoom = "30";
	portraitAngle = "2";
	portraitFOV = "28";
	portraitImageMale = "assets/client/ui/hud/malecivbanker_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivbanker_portrait";

	isTrainStop = true;
	
	addHotSpot = "15 13 0";
	addHotSpot = "23 9 0";
	
	//audio
	audioList = "SEL : trainstation_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 30;
	selectionIcon = true;
   
	//Naming
	nameKey = "trainstation_name";

};


/* Outpost -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Outpost Datablock
datablock CCmpBuildingData(OutpostData)
{
   hiderMax = 3;
   tenantMax = 0;
   employeeMax = 1;
   
   // door offset from position
   door = "2 7 0";

   // construction building properties

   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 2;
   constructionTime = 6;
   constructionPresentStart = 2;
   constructionPresentStop = 6;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -1 damage";

   // production building properties
   produceTime = 10;
   produceSelect = true;
   produceGold = "0 20 30";
   produceWood = "0 18 28";
   produceFood = "0 12 20";

   // destruction building properties
   destructionProp = "-3 0 ~/data/shapes/props/townProps/barrel.dts";
   destructionProp = "1 2 ~/data/shapes/props/townProps/box.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 2;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 16;
   repairGold = 8;
   repaitWood = 8;
   
   flammable = false;
   vulnerable = false;
   
   //work information
   workUniform = "banker";
   workerAI = "com_default";
   workItem = "Clipboard 2 male_and_female";
   workItem = "Conductorhat 0 male_and_female";
   workAnimation = "lookclipboard";
};

// Outpost Object
datablock SLGameObjData(Outpost)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   addCmpData = OutpostData;
   addCmpData = OutpostCmdData;
   
   shapeFile = "~/data/shapes/buildings/outpost.dts";
   
   // health
   healthMax = 200;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;
   canDamage = false;

   // resource requirements to build object
   goldCost = 120;
   woodCost = 120;

    //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "24 16";
	footprintSetRow = "0 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "1 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "2 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "3 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "4 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "5 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "6 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "7 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "8 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "9 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "10 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "11 5 5 5 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 5 5 5 5";
	footprintSetRow = "12 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "13 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "14 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "15 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintCenter = "12 8";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;

   // shadow for the object
	shadowDecal = OutpostShadowDecal;
	shadowScale = 6;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-1 -1";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 3.8";
	portraitRotation = "-20";
	portraitHeight = "8";
	portraitZoom = "25";
	portraitAngle = "2";
	portraitFOV = "22";
	portraitImageMale = "assets/client/ui/hud/malecivbanker_portrait";
	portraitImageFemale = "assets/client/ui/hud/femalecivbanker_portrait";
	
	addHotSpot = "15 13 0";
	addHotSpot = "23 9 90";
	
	isTrainStop = true;
	
	//audio
	audioList = "SEL : outpost_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
   
	//Naming
	nameKey = "outpost_name";
	
	// Construction finished sounds
	//constructSoundChance = "100";
	//mConstructSound = "m_civilian_PLT01 m_civilian_PLT02";
	//fConstructSound = "f_civilian_PLT01 f_civilian_PLT02";
};

/* Platform -----------------------------------------------------------------
-------------------------------------------------------------------------*/

// Platform Datablock
datablock CCmpBuildingData(PlatformData)
{
   hiderMax = 0;
   tenantMax = 0;
   employeeMax = 0;
   
   // door offset from position
   door = "-2 9 0";

   // construction building properties

   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionOffset = "0 0";
   constructionScale = 2;
   constructionTime = 6;
   constructionPresentStart = 2;
   constructionPresentStop = 6;

   // health and damage states for the building
   damageData = "100 0 base";

   // destruction building properties
   destructionProp = "-3 0 ~/data/shapes/props/townProps/barrel.dts";
   destructionProp = "1 2 ~/data/shapes/props/townProps/box.dts";
   destructDecal = DestructionDecal;
   destructEffect = DestructionEffect;
   destructionOffset = "0 0";
   destructionScale = 2;
   destructionTime = 6;
   
   // repair info
   repairTime = 3;
   repairAmount = 20;
   repairGold = 5;
   repaitWood = 5;
   
   //work information
   workUniform = "banker";
   workerAI = "com_default";
   workItem = "Clipboard 2 male_and_female";
   workItem = "Conductorhat 0 male_and_female";
   
   flammable = false;
   vulnerable = false;
};

// Platform Object
datablock SLGameObjData(Platform)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";
   
   // Components
   addCmpData = PlatformData;
   addCmpData = PlatformCmdData;

   shapeFile = "~/data/shapes/buildings/platform.dts";
   
   // health
   healthMax = 150;
   healthExtent = "112 14";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 0";
   healthImage = "~/client/ui/healthBarLong";
   healthBBoxHeight = true;

   // resource requirements to build object
   goldCost = 80;
   woodCost = 80;
   canDamage = false;

    //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "24 16";
	footprintSetRow = "0 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "1 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "2 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "3 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "4 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "5 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "6 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "7 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "8 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "9 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "10 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "11 1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1";
	footprintSetRow = "12 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "13 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "14 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintSetRow = "15 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1";
	footprintCenter = "12 8";

	// footprint texture binding
	bindFootprintTexture = "0 " @ $Texture::Construction;
	bindFootprintTexture = "1 " @ $Texture::Road;
	
   // shadow for the object
	shadowDecal = PlatformShadowDecal;
	shadowScale = 6.2;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "-.5 -.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	receiveLMLighting = false;
	
	portraitOffset = "0 0 1.5";
	portraitRotation = "15";
	portraitHeight = "8";
	portraitZoom = "33";
	portraitAngle = "3";
	portraitFOV = "25";
	
	isTrainStop = true;
	
	//audio
	audioList = "SEL : platform_SEL";
	audioList = "destruction : building_destruction";
	audioList = "construction : building_construction";
	
	sightRange = 20;
	selectionIcon = true;
   
	//Naming
	nameKey = "platform_name";
};

// BRIDGE

// end bridge piece
datablock CCmpBuildingData(BridgeEndData)
{
   // door offset from position
   door = "0 -6 0";
   
   // construction building properties
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/bridgeconstructprop.dts";
   constructionPropCount = 1;
   constructionProp = "0 -4 180 1 fence";
   constructionTime = 5;

   // health and damage states for the building
   damageData = "100 0 base";
   
   flammable = false;
	vulnerable = false;

   // destruction building properties
   destructionProp = "-4 1 0 .8 ~/data/shapes/props/townProps/destructionprop1.dts " @ $Detail::Medium;
   destructionProp = "0 0 0 .8 ~/data/shapes/props/townProps/destructionpropwood.dts"; 
   destructionTime = 10;
};

datablock SLGameObjData(BridgeEndLink)
{
   objTileOffset = "0 0";
   
   addCmpData = BridgeEndData;

   shapeFile = "~/data/shapes/props/townProps/bridgeend.dts";

   // health
   healthMax = 250;
   canDamage = false;
   
   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 5 5 5 5 5 5 5 5";
	footprintSetRow = "1 5 5 5 5 5 5 5 5";
	footprintSetRow = "2 0 0 1 1 1 1 0 0";
	footprintSetRow = "3 0 0 1 1 1 1 0 0";
	footprintSetRow = "4 0 0 1 1 1 1 0 0";
	footprintSetRow = "5 0 0 1 1 1 1 0 0";
	footprintSetRow = "6 0 0 1 1 1 1 0 0";
	footprintSetRow = "7 0 0 1 1 1 1 0 0";
	footprintCenter = "4 6";
	
	bindFootprintTexture = "1 " @ $Texture::Road;
	
	selectionIcon = true;
	receiveLMLighting = false;
	skipEditorLoad = true;
   
};

// middle bridge piece
datablock CCmpBuildingData(BridgeMiddleData)
{
   // construction building properties
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/bridgeconstructprop.dts";
   constructionPropCount = 1;
   constructDecal = ConstructionDecal;
   constructEffect = ConstructionEffect;
   constructionTime = 5;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -2 damage";

   // destruction building properties
   destructionProp = "-4 1 0 .7 ~/data/shapes/props/townProps/destructionprop1.dts " @ $Detail::Medium;
   destructionProp = "4 -2 0 .7 ~/data/shapes/props/townProps/destructionprop2.dts " @ $Detail::Medium;

   destructionTime = 2;
   
   flammable = false;
   vulnerable = false;
	
};

datablock SLGameObjData(BridgeMiddleLink)
{
   objTileOffset = "0 0";
   
   addCmpData = BridgeMiddleData;

   shapeFile = "~/data/shapes/props/townProps/bridgemid.dts";
   
   // health
   healthMax = 250;
   canDamage = false;
   
   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 4";
	footprintSetRow = "0 0 0 1 1 1 1 0 0";
	footprintSetRow = "1 0 0 1 1 1 1 0 0";
	footprintSetRow = "2 0 0 1 1 1 1 0 0";
	footprintSetRow = "3 0 0 1 1 1 1 0 0";
	footprintCenter = "4 2";
	
	bindFootprintTexture = "1 " @ $Texture::Road;

   selectionIcon = true;
	receiveLMLighting = false;
	skipEditorLoad = true;
   
};

// Bridge Datablock
datablock CCmpBuildingData(BridgeStartData)
{
   // door offset from position
   door = "0 6 0";
   
   // construction building properties
   constructionProp = "0 0 0 1 ~/data/shapes/props/townProps/bridgeconstructprop.dts";
   constructionPropCount = 1;
   constructionProp = "0 4 0 1 fence";
   constructionTime = 5;

   // health and damage states for the building
   damageData = "100 0 base";
   damageData = "50 -2 damage";

   // destruction building properties
   destructionProp = "0 0 0 1 ~/data/shapes/props/townProps/destructionpropwood.dts";
   destructionTime = 2;
   
   flammable = false;
   vulnerable = false;
	
};

datablock SLLinkObjData(Bridge)
{
   snapGrid = $SnapGrid::Terrain;
   objTileOffset = "0 0";

   addCmpData = BridgeStartData;
   addCmpData = BaseCmdData;

   shapeFile = "~/data/shapes/props/townProps/bridgestart.dts";
   
   // health
   healthMax = 250;
   canDamage = false;
   
   // resource requirements to build object
   goldCost = 100;
   woodCost = 120;
   
   //footprint
   footprintGrid = $SnapGrid::Object;
	footprintSize = "8 8";
	footprintSetRow = "0 0 0 1 1 1 1 0 0";
	footprintSetRow = "1 0 0 1 1 1 1 0 0";
	footprintSetRow = "2 0 0 1 1 1 1 0 0";
	footprintSetRow = "3 0 0 1 1 1 1 0 0";
	footprintSetRow = "4 0 0 1 1 1 1 0 0";
	footprintSetRow = "5 0 0 1 1 1 1 0 0";
	footprintSetRow = "6 5 5 5 5 5 5 5 5";
	footprintSetRow = "7 5 5 5 5 5 5 5 5";
	footprintCenter = "4 2";
	
	bindFootprintTexture = "1 " @ $Texture::Road;

	receiveLMLighting = false;
	
	portraitImage = "assets/client/ui/hud/bridge_portrait.jpg";
		
	startLink = "0 -4";
	middleLink = "BridgeMiddleLink 0 -4";
	endLink = "BridgeEndLink 0 -4";
	minLinkCount = 3;
	maxLinkCount = 8;
	
	sightRange = 0;
	selectionIcon = true;
	
	// Construction finished sounds
	mConstructSound = "m_civilian_BRI01 m_civilian_BRI02";
	fConstructSound = "f_civilian_BRI01 f_civilian_BRI02 f_civilian_BRI03";
   
};
